#include "btDebugDraw.h"

#include <d3dx9.h>


//̕`Ɏg_tH[}bg
struct VERTEX{
	D3DXVECTOR3 pos ;
	D3DCOLOR color ;

	static const DWORD FVF = (D3DFVF_XYZ | D3DFVF_DIFFUSE);
};


//RXgN^
//yF`ɎgfoCXz
CBtDebugDraw::CBtDebugDraw(LPDIRECT3DDEVICE9 pD3DDevice):
//debugDrawMode̓ftHgŃC[t[݂̂`悷悤ɂĂ
_debugDrawMode(btIDebugDraw::DBG_DrawWireframe), _pD3DDevice(pD3DDevice)
{
	return;
}



//̕`
//y߂lFȂzyF̊Jnʒu, ̏Iʒu, ̐Fz
void CBtDebugDraw::drawLine(const btVector3 &from, const btVector3 &to, const btVector3 &color)
{
	D3DXMATRIX mWorld ;
	VERTEX vertex[2] ;


	//ʒuݒ
	vertex[0].pos = D3DXVECTOR3(from.x( ), from.y( ), from.z( ));
	vertex[1].pos = D3DXVECTOR3(to.x( ), to.y( ), to.z( ));
	//Fcolorx, y, zɐ, , Ή0.0`1.0̊Ԃ̒lœĂ
	vertex[0].color = D3DCOLOR_XRGB(static_cast<int>(color.x( ) * 255),
		static_cast<int>(color.y( ) * 255), static_cast<int>(color.z( ) * 255));
	vertex[1].color = vertex[0].color;

	//_tH[}bg̐ݒ
	_pD3DDevice->SetFVF(vertex[0].FVF);
	//eNX`ZbgȂݒɂ
	_pD3DDevice->SetTexture(0, NULL);
	//Pʍs̐ݒ
	D3DXMatrixIdentity(&mWorld);
	_pD3DDevice->SetTransform(D3DTS_WORLD, &mWorld);
	//C[t[̕`
	_pD3DDevice->DrawPrimitiveUP(D3DPT_LINELIST, 1, &vertex[0], sizeof(vertex[0]));


	return;
}



//IuWFNgm̐ړ_`
//y߂lFȂzyFڐG_, ڐG_̖@, ڐG, ̒l(ɎgĂȂ), Fz
void CBtDebugDraw::drawContactPoint(const btVector3 &PointOnB, const btVector3 &normalOnB, btScalar distance, int lifeTime, const btVector3 &color)
{
	drawLine(PointOnB, PointOnB + (normalOnB * distance), color);


	return;
}



//fobO[h̐ݒ
//y߂lFȂzyFݒ肵fobO[hz
void CBtDebugDraw::setDebugMode(int debugMode)
{
	_debugDrawMode = static_cast<DebugDrawModes>(debugMode);


	return;
}



//fobO[h̎擾
//y߂lFfobO[hzyFȂz
int CBtDebugDraw::getDebugMode(void) const
{
	return _debugDrawMode;
}


